@extends('admin.layout.page-app')
@section('page_title', __('label.dashboard'))
@section('tab_title', __('label.dashboard'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.dashboard')}}</h1>

            <?php $config = Quiz_Configuration(); ?>

            <!-- Card -->
            <div class="row counter-row">
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-users fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_user ?? 0) }}</h3>
                                <span>{{__('label.users')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-shapes fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_category ?? 0) }}</h3>
                                <span>{{__('label.category')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-lightbulb fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_skill ?? 0) }}</h3>
                                <span>{{__('label.skill')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-table-cells-large fa-2x"></i> 
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_classification ?? 0) }}</h3>
                                <span>{{__('label.classification')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-layer-group fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_level ?? 0) }}</h3>
                                <span>{{__('label.level')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-face-smile fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_avatar ?? 0) }}</h3>
                                <span>{{__('label.avatar')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @if(isset($config[0]) && $config[0]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_pratice_question ?? 0) }}</h3>
                                    <span>{{__('label.pratice_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[1]) && $config[1]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_normal_question ?? 0) }}</h3>
                                    <span>{{__('label.normal_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[2]) && $config[2]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_audio_question ?? 0) }}</h3>
                                    <span>{{__('label.audio_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[3]) && $config[3]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_video_question ?? 0) }}</h3>
                                    <span>{{__('label.video_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[4]) && $config[4]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_true_false_question ?? 0) }}</h3>
                                    <span>{{__('label.true_false_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[8]) && $config[8]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_daily_quiz_question ?? 0) }}</h3>
                                    <span>{{__('label.daily_quiz_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[5]) && $config[5]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_fear_factor_question ?? 0) }}</h3>
                                    <span>{{__('label.fear_factor_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[6]) && $config[6]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-bullseye fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_ultimate_challenges ?? 0) }}</h3>
                                    <span>{{__('label.ultimate_challenges')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[7]) && $config[7]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-award fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_contests ?? 0) }}</h3>
                                    <span>{{__('label.contests')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[11]) && $config[11]['quiz_status'] == 1)
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-file-alt fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_exams ?? 0) }}</h3>
                                    <span>{{__('label.exams')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                @if(isset($config[9]) && isset($config[10]) && ($config[9]['quiz_status'] == 1 || $config[10]['quiz_status'] == 1))
                    <div class="col-xl-3 col-sm-6 col-12 mb-2">
                        <div class="card custom-card card-color-primary">
                            <div class="card-body">
                                <div class="card-icon-primary card-color-primary">
                                    <i class="fa-solid fa-circle-question fa-2x"></i> 
                                </div>
                                <div class="text-right">
                                    <h3>{{ No_Format($total_battles_question ?? 0) }}</h3>
                                    <span>{{__('label.battles_questions')}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if($config[9]['quiz_status'] == 1)
                        <div class="col-xl-3 col-sm-6 col-12 mb-2">
                            <div class="card custom-card card-color-primary">
                                <div class="card-body">
                                    <div class="card-icon-primary card-color-primary">
                                        <i class="fa-solid fa-user-friends fa-2x"></i> 
                                    </div>
                                    <div class="text-right">
                                        <h3>{{ No_Format($total_1_vs_1_battles ?? 0) }}</h3>
                                        <span>{{__('label.1_vs_1_battles')}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($config[10]['quiz_status'] == 1)
                        <div class="col-xl-3 col-sm-6 col-12 mb-2">
                            <div class="card custom-card card-color-primary">
                                <div class="card-body">
                                    <div class="card-icon-primary card-color-primary">
                                        <i class="fa-solid fa-users fa-2x"></i> 
                                    </div>
                                    <div class="text-right">
                                        <h3>{{ No_Format($total_group_battles ?? 0) }}</h3>
                                        <span>{{__('label.group_battles')}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-box-archive fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_package ?? 0) }}</h3>
                                <span>{{__('label.packages')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-store fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_product ?? 0) }}</h3>
                                <span>{{__('label.products')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- User Statistice && Most Subscribed Channel -->
            <div class="row px-3">
                <div class="col-12 cart-bg">
                    <div class="box-title">
                        <h2 class="title"><i class="fa-solid fa-chart-column fa-lg mr-2"></i>{{__('label.join_users_statistice')}}</h2>
                        <a href="{{ route('admin.user.index')}}" class="btn btn-link">{{__('label.view_all')}}</a>
                    </div>
                    <div class="row mt-2">
                        <div class="col-12 col-sm-12">
                            <Button id="year" class="btn btn-default">{{__('label.this_year')}}</Button>
                            <Button id="month" class="btn btn-default">{{__('label.this_month')}}</Button>
                        </div>
                    </div>
                    <div class="summary-table-card mt-2">
                        <div id="User_Chart"></div>
                    </div>
                </div>
            </div>

            <!-- Card -->
            <div class="row counter-row mt-4">
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-money-bill-trend-up fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_current_month ?? 0) }} {{ Currency_Code() }}</h3>
                                <span>{{__('label.package_earning')}} ({{ date('M') }})</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-money-bill-trend-up fa-2x"></i>
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_year ?? 0) }} {{ Currency_Code() }}</h3>
                                <span>{{__('label.package_earning')}} ({{ date('Y') }})</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-arrow-trend-up fa-2x"></i> 
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_request_pending ?? 0) }} {{ Currency_Code() }}</h3>
                                <span>{{__('label.pending_withdrawal')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card custom-card card-color-primary">
                        <div class="card-body">
                            <div class="card-icon-primary card-color-primary">
                                <i class="fa-solid fa-arrow-trend-down fa-2x"></i> 
                            </div>
                            <div class="text-right">
                                <h3>{{ No_Format($total_request_completed ?? 0) }} {{ Currency_Code() }}</h3>
                                <span>{{__('label.completed_withdrawal')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Package Earning && Withdrawal Statistice -->
            <div class="row pl-3">
                <div class="col-12 col-xl-8 cart-bg">
                    <div class="box-title">
                        <h2 class="title"><i class="fa-solid fa-chart-line fa-lg mr-2"></i>{{__('label.package_earning_statistice_current_year')}}</h2>
                        <a href="{{ route('admin.transaction.index') }}" class="btn btn-link">{{__('label.view_all')}}</a>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div id="PlanEarningChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-xl-4">
                    <div class="video-box pb-2">
                        <div class="box-title mt-0">
                            <h2 class="title"><i class="fa-solid fa-chart-pie fa-lg mr-2"></i>{{__('label.withdrawal_current_year')}}</h2>
                            <a href="{{ route('admin.withdrawal.index') }}" class="btn btn-link">{{__('label.view_all')}}</a>
                        </div>
                        <div class="summary-table-card mt-2">
                            <div id="WithdrawalChart"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>          
    </div>
@endsection

@section('pagescript')
    <!-- Chart -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        // User Chart
        let userYear = JSON.parse(`<?php echo $user_year ?>`);
        let userMonth = JSON.parse(`<?php echo $user_month ?>`);
        let chartOptions = {
            chart: {
                type: 'bar',
                height: 400,
                toolbar: { show: false }
            },
            dataLabels: {
                enabled: false
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '70%',
                    endingShape: 'rounded'
                }
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shade: 'light',
                    type: 'vertical',
                    shadeIntensity: 0.5,
                    gradientToColors: ['#4e45b8'],
                    inverseColors: false,
                    opacityFrom: 1,
                    opacityTo: 0.8,
                    stops: [0, 100]
                }
            },
            colors: ['#6a11cb', '#f7971e'],
            grid: {
                borderColor: '#9a9a9a',
                strokeDashArray: 4
            },
            tooltip: {
                theme: 'dark',
                style: {
                    fontSize: '14px'
                }
            },
            series: [],
            xaxis: {
                categories: []
            },
            legend: {
                position: 'bottom',
                fontSize: '16px',
                fontWeight: 'bold',
                labels: {
                    colors: ['#333'],
                    useSeriesColors: false
                }
            },
        };

        let chart = new ApexCharts(document.querySelector("#User_Chart"), chartOptions);
        chart.render();

        function loadChartData(type) {
            if (type === 'year') {
                chart.updateOptions({
                    series: [
                        { name: "{{ __('label.users') }}", data: userYear.sum },
                    ],
                    xaxis: {
                        categories: [
                            '{{__("label.jan")}}', '{{__("label.feb")}}', '{{__("label.mar")}}', '{{__("label.apr")}}',
                            '{{__("label.may")}}', '{{__("label.jun")}}', '{{__("label.jul")}}', '{{__("label.aug")}}',
                            '{{__("label.sep")}}', '{{__("label.oct")}}', '{{__("label.nov")}}', '{{__("label.dec")}}'
                        ],
                        labels: {
                            style: {
                                fontSize: '14px',
                                fontWeight: 'bold'
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: {
                                fontSize: '14px',
                                fontWeight: 'bold'
                            }
                        }
                    },
                });
            } else {
                let daysInMonth = userMonth.sum.length;
                chart.updateOptions({
                    series: [
                        { name: "{{ __('label.users') }}", data: userMonth.sum },
                    ],
                    xaxis: {
                        categories: Array.from({ length: daysInMonth }, (_, i) => (i + 1).toString())
                    },
                });
            }
        }

        loadChartData('year');
        document.getElementById('year').addEventListener('click', function () {
            loadChartData('year');
        });
        document.getElementById('month').addEventListener('click', function () {
            loadChartData('month');
        });

        const currencySymbol = `{{ Currency_Code() }}`;
        document.addEventListener("DOMContentLoaded", function () {
            // Plan Earning
            const cData = JSON.parse(`<?php echo $package ?>`);
            const months = ['{{__("label.jan")}}', '{{__("label.feb")}}', '{{__("label.mar")}}', '{{__("label.apr")}}',
                            '{{__("label.may")}}', '{{__("label.jun")}}', '{{__("label.jul")}}', '{{__("label.aug")}}',
                            '{{__("label.sep")}}', '{{__("label.oct")}}', '{{__("label.nov")}}', '{{__("label.dec")}}'];

            const series = [];
            for (let i = 0; i < cData.label.length; i++) {
                series.push({
                    name: cData.label[i],
                    data: cData.sum[i]
                });
            }
            const options = {
                chart: {
                    type: 'line',
                    height: 400,
                    toolbar: { show: false }
                },
                series: series,
                xaxis: {
                    categories: months,
                    labels: {
                        style: {
                            fontSize: '14px',
                            fontWeight: 'bold'
                        }
                    }
                },
                yaxis: {
                    labels: {
                        style: {
                            fontSize: '14px',
                            fontWeight: 'bold'
                        }
                    }
                },
                stroke: {
                    curve: 'smooth',
                    width: 3
                },
                grid: {
                    borderColor: '#9a9a9a',
                    strokeDashArray: 4
                },
                tooltip: {
                    theme: 'dark',
                    style: {
                        fontSize: '14px'
                    },
                    y: {
                        formatter: function (value) {
                            return value + ' ' + currencySymbol;
                        }
                    }
                },
                colors: ['#4e45b8', '#ff9700', '#058f00', '#3498db', '#9b19f5', '#1abc9c', '#ff6f61', '#692705'],
                legend: {
                    position: 'bottom',
                    fontSize: '16px',
                    fontWeight: 'bold',
                    labels: {
                        colors: ['#333'],
                        useSeriesColors: false
                    }
                },
            };
            new ApexCharts(document.querySelector("#PlanEarningChart"), options).render();

            // Withdrawal
            const withdrawalData = JSON.parse(`<?php echo $withdrawal_earning ?>`);
            const withdrawal_option = {
                chart: {
                    type: 'donut',
                    height: 400,
                },
                series: withdrawalData.sum,
                labels: ["Pending", "Completed"],
                colors: ['#e3000b', '#058f00'],
                plotOptions: {
                    pie: {
                        startAngle: -90,
                        endAngle: 90,
                        offsetY: 10
                    }
                },
                dataLabels: {
                    enabled: false
                },
                fill: {
                    type: 'gradient',
                },
                tooltip: {
                    y: {
                        formatter: function (value) {
                            return value + ' ' + currencySymbol;
                        }
                    }
                },
                legend: {
                    position: 'bottom',
                    fontSize: '18px',
                    fontWeight: 'bold',
                    offsetY: -90,
                    labels: {
                        colors: ['#333'],
                        useSeriesColors: false
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: { width: 300 },
                        legend: {
                            position: 'bottom',
                            offsetY: -5
                        }
                    }
                }]
            };
            new ApexCharts(document.querySelector("#WithdrawalChart"), withdrawal_option).render();
        });
    </script>
@endsection